/**
 * Use this provider to authenticate with Spotify.
 *
 * ```ts {5-8}
 * import { SpotifyProvider } from "@openauthjs/openauth/provider/spotify"
 *
 * export default issuer({
 *   providers: {
 *     spotify: SpotifyProvider({
 *       clientID: "1234567890",
 *       clientSecret: "0987654321"
 *     })
 *   }
 * })
 * ```
 *
 * @packageDocumentation
 */
import { type Oauth2WrappedConfig } from "./oauth2.js";
export interface SpotifyConfig extends Oauth2WrappedConfig {
}
/**
 * Create a Spotify OAuth2 provider.
 *
 * @param config - The config for the provider.
 * @example
 * ```ts
 * SpotifyProvider({
 *   clientID: "1234567890",
 *   clientSecret: "0987654321"
 * })
 * ```
 */
export declare function SpotifyProvider(config: SpotifyConfig): import("./provider.js").Provider<{
    tokenset: import("./oauth2.js").Oauth2Token;
    clientID: string;
}>;
//# sourceMappingURL=spotify.d.ts.map