/**
 * Use this provider to authenticate with Twitch.
 *
 * ```ts {5-8}
 * import { TwitchProvider } from "@openauthjs/openauth/provider/twitch"
 *
 * export default issuer({
 *   providers: {
 *     twitch: TwitchProvider({
 *       clientID: "1234567890",
 *       clientSecret: "0987654321"
 *     })
 *   }
 * })
 * ```
 *
 * @packageDocumentation
 */
import { Oauth2WrappedConfig } from "./oauth2.js";
export interface TwitchConfig extends Oauth2WrappedConfig {
}
/**
 * Create a Twitch OAuth2 provider.
 *
 * @param config - The config for the provider.
 * @example
 * ```ts
 * TwitchProvider({
 *   clientID: "1234567890",
 *   clientSecret: "0987654321"
 * })
 * ```
 */
export declare function TwitchProvider(config: TwitchConfig): import("./provider.js").Provider<{
    tokenset: import("./oauth2.js").Oauth2Token;
    clientID: string;
}>;
//# sourceMappingURL=twitch.d.ts.map