/**
 * Use this provider to authenticate with X.com.
 *
 * ```ts {5-8}
 * import { XProvider } from "@openauthjs/openauth/provider/x"
 *
 * export default issuer({
 *   providers: {
 *     x: XProvider({
 *       clientID: "1234567890",
 *       clientSecret: "0987654321"
 *     })
 *   }
 * })
 * ```
 *
 * @packageDocumentation
 */
import { Oauth2WrappedConfig } from "./oauth2.js";
export interface XProviderConfig extends Oauth2WrappedConfig {
}
/**
 * Create a X.com OAuth2 provider.
 *
 * @param config - The config for the provider.
 * @example
 * ```ts
 * XProvider({
 *   clientID: "1234567890",
 *   clientSecret: "0987654321"
 * })
 * ```
 */
export declare function XProvider(config: XProviderConfig): import("./provider.js").Provider<{
    tokenset: import("./oauth2.js").Oauth2Token;
    clientID: string;
}>;
//# sourceMappingURL=x.d.ts.map