/**
 * Use this provider to authenticate with Yahoo.
 *
 * ```ts {5-8}
 * import { YahooProvider } from "@openauthjs/openauth/provider/yahoo"
 *
 * export default issuer({
 *   providers: {
 *     yahoo: YahooProvider({
 *       clientID: "1234567890",
 *       clientSecret: "0987654321"
 *     })
 *   }
 * })
 * ```
 *
 * @packageDocumentation
 */
import { Oauth2WrappedConfig } from "./oauth2.js";
export interface YahooConfig extends Oauth2WrappedConfig {
}
/**
 * Create a Yahoo OAuth2 provider.
 *
 * @param config - The config for the provider.
 * @example
 * ```ts
 * YahooProvider({
 *   clientID: "1234567890",
 *   clientSecret: "0987654321"
 * })
 * ```
 */
export declare function YahooProvider(config: YahooConfig): import("./provider.js").Provider<{
    tokenset: import("./oauth2.js").Oauth2Token;
    clientID: string;
}>;
//# sourceMappingURL=yahoo.d.ts.map