/**
 * Use this provider to authenticate with JumpCloud.
 *
 * ```ts {5-8}
 * import { JumpCloudProvider } from "@openauthjs/openauth/provider/jumpcloud"
 *
 * export default issuer({
 *   providers: {
 *     jumpcloud: JumpCloudProvider({
 *       clientID: "1234567890",
 *       clientSecret: "0987654321"
 *     })
 *   }
 * })
 * ```
 *
 * @packageDocumentation
 */
import { Oauth2WrappedConfig } from "./oauth2.js";
export interface JumpCloudConfig extends Oauth2WrappedConfig {
}
/**
 * Create a JumpCloud OAuth2 provider.
 *
 * @param config - The config for the provider.
 * @example
 * ```ts
 * JumpCloudProvider({
 *   clientID: "1234567890",
 *   clientSecret: "0987654321"
 * })
 * ```
 */
export declare function JumpCloudProvider(config: JumpCloudConfig): import("./provider.js").Provider<{
    tokenset: import("./oauth2.js").Oauth2Token;
    clientID: string;
}>;
//# sourceMappingURL=jumpcloud.d.ts.map