export * from "./gen/types.gen.js";
export { OpencodeClient };
import { createClient } from "./gen/client/client.gen.js";
import { OpencodeClient } from "./gen/sdk.gen.js";
export function createOpencodeClient(config) {
    if (!config?.fetch) {
        config = {
            ...config,
            fetch: (req) => {
                // @ts-ignore
                req.timeout = false;
                return fetch(req);
            },
        };
    }
    if (config?.directory) {
        config.headers = {
            ...config.headers,
            "x-opencode-directory": config.directory,
        };
    }
    const client = createClient(config);
    return new OpencodeClient({ client });
}
