// This file is auto-generated by @hey-api/openapi-ts
import { client as _heyApiClient } from "./client.gen.js";
class _HeyApiClient {
    _client = _heyApiClient;
    constructor(args) {
        if (args?.client) {
            this._client = args.client;
        }
    }
}
class Global extends _HeyApiClient {
    /**
     * Get events
     */
    event(options) {
        return (options?.client ?? this._client).get.sse({
            url: "/global/event",
            ...options,
        });
    }
}
class Project extends _HeyApiClient {
    /**
     * List all projects
     */
    list(options) {
        return (options?.client ?? this._client).get({
            url: "/project",
            ...options,
        });
    }
    /**
     * Get the current project
     */
    current(options) {
        return (options?.client ?? this._client).get({
            url: "/project/current",
            ...options,
        });
    }
}
class Pty extends _HeyApiClient {
    /**
     * List all PTY sessions
     */
    list(options) {
        return (options?.client ?? this._client).get({
            url: "/pty",
            ...options,
        });
    }
    /**
     * Create a new PTY session
     */
    create(options) {
        return (options?.client ?? this._client).post({
            url: "/pty",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
    /**
     * Remove a PTY session
     */
    remove(options) {
        return (options.client ?? this._client).delete({
            url: "/pty/{id}",
            ...options,
        });
    }
    /**
     * Get PTY session info
     */
    get(options) {
        return (options.client ?? this._client).get({
            url: "/pty/{id}",
            ...options,
        });
    }
    /**
     * Update PTY session
     */
    update(options) {
        return (options.client ?? this._client).put({
            url: "/pty/{id}",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Connect to a PTY session
     */
    connect(options) {
        return (options.client ?? this._client).get({
            url: "/pty/{id}/connect",
            ...options,
        });
    }
}
class Config extends _HeyApiClient {
    /**
     * Get config info
     */
    get(options) {
        return (options?.client ?? this._client).get({
            url: "/config",
            ...options,
        });
    }
    /**
     * Update config
     */
    update(options) {
        return (options?.client ?? this._client).patch({
            url: "/config",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
    /**
     * List all providers
     */
    providers(options) {
        return (options?.client ?? this._client).get({
            url: "/config/providers",
            ...options,
        });
    }
}
class Tool extends _HeyApiClient {
    /**
     * List all tool IDs (including built-in and dynamically registered)
     */
    ids(options) {
        return (options?.client ?? this._client).get({
            url: "/experimental/tool/ids",
            ...options,
        });
    }
    /**
     * List tools with JSON schema parameters for a provider/model
     */
    list(options) {
        return (options.client ?? this._client).get({
            url: "/experimental/tool",
            ...options,
        });
    }
}
class Instance extends _HeyApiClient {
    /**
     * Dispose the current instance
     */
    dispose(options) {
        return (options?.client ?? this._client).post({
            url: "/instance/dispose",
            ...options,
        });
    }
}
class Path extends _HeyApiClient {
    /**
     * Get the current path
     */
    get(options) {
        return (options?.client ?? this._client).get({
            url: "/path",
            ...options,
        });
    }
}
class Vcs extends _HeyApiClient {
    /**
     * Get VCS info for the current instance
     */
    get(options) {
        return (options?.client ?? this._client).get({
            url: "/vcs",
            ...options,
        });
    }
}
class Session extends _HeyApiClient {
    /**
     * List all sessions
     */
    list(options) {
        return (options?.client ?? this._client).get({
            url: "/session",
            ...options,
        });
    }
    /**
     * Create a new session
     */
    create(options) {
        return (options?.client ?? this._client).post({
            url: "/session",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
    /**
     * Get session status
     */
    status(options) {
        return (options?.client ?? this._client).get({
            url: "/session/status",
            ...options,
        });
    }
    /**
     * Delete a session and all its data
     */
    delete(options) {
        return (options.client ?? this._client).delete({
            url: "/session/{id}",
            ...options,
        });
    }
    /**
     * Get session
     */
    get(options) {
        return (options.client ?? this._client).get({
            url: "/session/{id}",
            ...options,
        });
    }
    /**
     * Update session properties
     */
    update(options) {
        return (options.client ?? this._client).patch({
            url: "/session/{id}",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Get a session's children
     */
    children(options) {
        return (options.client ?? this._client).get({
            url: "/session/{id}/children",
            ...options,
        });
    }
    /**
     * Get the todo list for a session
     */
    todo(options) {
        return (options.client ?? this._client).get({
            url: "/session/{id}/todo",
            ...options,
        });
    }
    /**
     * Analyze the app and create an AGENTS.md file
     */
    init(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/init",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Fork an existing session at a specific message
     */
    fork(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/fork",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Abort a session
     */
    abort(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/abort",
            ...options,
        });
    }
    /**
     * Unshare the session
     */
    unshare(options) {
        return (options.client ?? this._client).delete({
            url: "/session/{id}/share",
            ...options,
        });
    }
    /**
     * Share a session
     */
    share(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/share",
            ...options,
        });
    }
    /**
     * Get the diff for this session
     */
    diff(options) {
        return (options.client ?? this._client).get({
            url: "/session/{id}/diff",
            ...options,
        });
    }
    /**
     * Summarize the session
     */
    summarize(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/summarize",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * List messages for a session
     */
    messages(options) {
        return (options.client ?? this._client).get({
            url: "/session/{id}/message",
            ...options,
        });
    }
    /**
     * Create and send a new message to a session
     */
    prompt(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/message",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Get a message from a session
     */
    message(options) {
        return (options.client ?? this._client).get({
            url: "/session/{id}/message/{messageID}",
            ...options,
        });
    }
    /**
     * Create and send a new message to a session, start if needed and return immediately
     */
    promptAsync(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/prompt_async",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Send a new command to a session
     */
    command(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/command",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Run a shell command
     */
    shell(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/shell",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Revert a message
     */
    revert(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/revert",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Restore all reverted messages
     */
    unrevert(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/unrevert",
            ...options,
        });
    }
}
class Command extends _HeyApiClient {
    /**
     * List all commands
     */
    list(options) {
        return (options?.client ?? this._client).get({
            url: "/command",
            ...options,
        });
    }
}
class Oauth extends _HeyApiClient {
    /**
     * Authorize a provider using OAuth
     */
    authorize(options) {
        return (options.client ?? this._client).post({
            url: "/provider/{id}/oauth/authorize",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    /**
     * Handle OAuth callback for a provider
     */
    callback(options) {
        return (options.client ?? this._client).post({
            url: "/provider/{id}/oauth/callback",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
}
class Provider extends _HeyApiClient {
    /**
     * List all providers
     */
    list(options) {
        return (options?.client ?? this._client).get({
            url: "/provider",
            ...options,
        });
    }
    /**
     * Get provider authentication methods
     */
    auth(options) {
        return (options?.client ?? this._client).get({
            url: "/provider/auth",
            ...options,
        });
    }
    oauth = new Oauth({ client: this._client });
}
class Find extends _HeyApiClient {
    /**
     * Find text in files
     */
    text(options) {
        return (options.client ?? this._client).get({
            url: "/find",
            ...options,
        });
    }
    /**
     * Find files
     */
    files(options) {
        return (options.client ?? this._client).get({
            url: "/find/file",
            ...options,
        });
    }
    /**
     * Find workspace symbols
     */
    symbols(options) {
        return (options.client ?? this._client).get({
            url: "/find/symbol",
            ...options,
        });
    }
}
class File extends _HeyApiClient {
    /**
     * List files and directories
     */
    list(options) {
        return (options.client ?? this._client).get({
            url: "/file",
            ...options,
        });
    }
    /**
     * Read a file
     */
    read(options) {
        return (options.client ?? this._client).get({
            url: "/file/content",
            ...options,
        });
    }
    /**
     * Get file status
     */
    status(options) {
        return (options?.client ?? this._client).get({
            url: "/file/status",
            ...options,
        });
    }
}
class App extends _HeyApiClient {
    /**
     * Write a log entry to the server logs
     */
    log(options) {
        return (options?.client ?? this._client).post({
            url: "/log",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
    /**
     * List all agents
     */
    agents(options) {
        return (options?.client ?? this._client).get({
            url: "/agent",
            ...options,
        });
    }
}
class Mcp extends _HeyApiClient {
    /**
     * Get MCP server status
     */
    status(options) {
        return (options?.client ?? this._client).get({
            url: "/mcp",
            ...options,
        });
    }
    /**
     * Add MCP server dynamically
     */
    add(options) {
        return (options?.client ?? this._client).post({
            url: "/mcp",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
}
class Lsp extends _HeyApiClient {
    /**
     * Get LSP server status
     */
    status(options) {
        return (options?.client ?? this._client).get({
            url: "/lsp",
            ...options,
        });
    }
}
class Formatter extends _HeyApiClient {
    /**
     * Get formatter status
     */
    status(options) {
        return (options?.client ?? this._client).get({
            url: "/formatter",
            ...options,
        });
    }
}
class Control extends _HeyApiClient {
    /**
     * Get the next TUI request from the queue
     */
    next(options) {
        return (options?.client ?? this._client).get({
            url: "/tui/control/next",
            ...options,
        });
    }
    /**
     * Submit a response to the TUI request queue
     */
    response(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/control/response",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
}
class Tui extends _HeyApiClient {
    /**
     * Append prompt to the TUI
     */
    appendPrompt(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/append-prompt",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
    /**
     * Open the help dialog
     */
    openHelp(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/open-help",
            ...options,
        });
    }
    /**
     * Open the session dialog
     */
    openSessions(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/open-sessions",
            ...options,
        });
    }
    /**
     * Open the theme dialog
     */
    openThemes(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/open-themes",
            ...options,
        });
    }
    /**
     * Open the model dialog
     */
    openModels(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/open-models",
            ...options,
        });
    }
    /**
     * Submit the prompt
     */
    submitPrompt(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/submit-prompt",
            ...options,
        });
    }
    /**
     * Clear the prompt
     */
    clearPrompt(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/clear-prompt",
            ...options,
        });
    }
    /**
     * Execute a TUI command (e.g. agent_cycle)
     */
    executeCommand(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/execute-command",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
    /**
     * Show a toast notification in the TUI
     */
    showToast(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/show-toast",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
    /**
     * Publish a TUI event
     */
    publish(options) {
        return (options?.client ?? this._client).post({
            url: "/tui/publish",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options?.headers,
            },
        });
    }
    control = new Control({ client: this._client });
}
class Auth extends _HeyApiClient {
    /**
     * Set authentication credentials
     */
    set(options) {
        return (options.client ?? this._client).put({
            url: "/auth/{id}",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
}
class Event extends _HeyApiClient {
    /**
     * Get events
     */
    subscribe(options) {
        return (options?.client ?? this._client).get.sse({
            url: "/event",
            ...options,
        });
    }
}
export class OpencodeClient extends _HeyApiClient {
    /**
     * Respond to a permission request
     */
    postSessionIdPermissionsPermissionId(options) {
        return (options.client ?? this._client).post({
            url: "/session/{id}/permissions/{permissionID}",
            ...options,
            headers: {
                "Content-Type": "application/json",
                ...options.headers,
            },
        });
    }
    global = new Global({ client: this._client });
    project = new Project({ client: this._client });
    pty = new Pty({ client: this._client });
    config = new Config({ client: this._client });
    tool = new Tool({ client: this._client });
    instance = new Instance({ client: this._client });
    path = new Path({ client: this._client });
    vcs = new Vcs({ client: this._client });
    session = new Session({ client: this._client });
    command = new Command({ client: this._client });
    provider = new Provider({ client: this._client });
    find = new Find({ client: this._client });
    file = new File({ client: this._client });
    app = new App({ client: this._client });
    mcp = new Mcp({ client: this._client });
    lsp = new Lsp({ client: this._client });
    formatter = new Formatter({ client: this._client });
    tui = new Tui({ client: this._client });
    auth = new Auth({ client: this._client });
    event = new Event({ client: this._client });
}
