// src/ui/password.tsx
import { Layout } from "./base.js";
import"./form.js";
import { FormAlert } from "./form.js";
import { jsxDEV, Fragment } from "hono/jsx/jsx-dev-runtime";
var DEFAULT_COPY = {
  error_email_taken: "There is already an account with this email.",
  error_invalid_code: "Code is incorrect.",
  error_invalid_email: "Email is not valid.",
  error_invalid_password: "Password is incorrect.",
  error_password_mismatch: "Passwords do not match.",
  error_validation_error: "Password does not meet requirements.",
  register_title: "Welcome to the app",
  register_description: "Sign in with your email",
  login_title: "Welcome to the app",
  login_description: "Sign in with your email",
  register: "Register",
  register_prompt: "Don't have an account?",
  login_prompt: "Already have an account?",
  login: "Login",
  change_prompt: "Forgot password?",
  code_resend: "Resend code",
  code_return: "Back to",
  logo: "A",
  input_email: "Email",
  input_password: "Password",
  input_code: "Code",
  input_repeat: "Repeat password",
  button_continue: "Continue"
};
function PasswordUI(input) {
  const copy = {
    ...DEFAULT_COPY,
    ...input.copy
  };
  return {
    validatePassword: input.validatePassword,
    sendCode: input.sendCode,
    login: async (_req, form, error) => {
      const jsx = /* @__PURE__ */ jsxDEV(Layout, {
        children: /* @__PURE__ */ jsxDEV("form", {
          "data-component": "form",
          method: "post",
          children: [
            /* @__PURE__ */ jsxDEV(FormAlert, {
              message: error?.type && copy?.[`error_${error.type}`]
            }, undefined, false, undefined, this),
            /* @__PURE__ */ jsxDEV("input", {
              "data-component": "input",
              type: "email",
              name: "email",
              required: true,
              placeholder: copy.input_email,
              autofocus: !error,
              value: form?.get("email")?.toString()
            }, undefined, false, undefined, this),
            /* @__PURE__ */ jsxDEV("input", {
              "data-component": "input",
              autofocus: error?.type === "invalid_password",
              required: true,
              type: "password",
              name: "password",
              placeholder: copy.input_password,
              autoComplete: "current-password"
            }, undefined, false, undefined, this),
            /* @__PURE__ */ jsxDEV("button", {
              "data-component": "button",
              children: copy.button_continue
            }, undefined, false, undefined, this),
            /* @__PURE__ */ jsxDEV("div", {
              "data-component": "form-footer",
              children: [
                /* @__PURE__ */ jsxDEV("span", {
                  children: [
                    copy.register_prompt,
                    " ",
                    /* @__PURE__ */ jsxDEV("a", {
                      "data-component": "link",
                      href: "register",
                      children: copy.register
                    }, undefined, false, undefined, this)
                  ]
                }, undefined, true, undefined, this),
                /* @__PURE__ */ jsxDEV("a", {
                  "data-component": "link",
                  href: "change",
                  children: copy.change_prompt
                }, undefined, false, undefined, this)
              ]
            }, undefined, true, undefined, this)
          ]
        }, undefined, true, undefined, this)
      }, undefined, false, undefined, this);
      return new Response(jsx.toString(), {
        status: error ? 401 : 200,
        headers: {
          "Content-Type": "text/html"
        }
      });
    },
    register: async (_req, state, form, error) => {
      const emailError = ["invalid_email", "email_taken"].includes(error?.type || "");
      const passwordError = [
        "invalid_password",
        "password_mismatch",
        "validation_error"
      ].includes(error?.type || "");
      const jsx = /* @__PURE__ */ jsxDEV(Layout, {
        children: /* @__PURE__ */ jsxDEV("form", {
          "data-component": "form",
          method: "post",
          children: [
            /* @__PURE__ */ jsxDEV(FormAlert, {
              message: error?.type ? error.type === "validation_error" ? error.message ?? copy?.[`error_${error.type}`] : copy?.[`error_${error.type}`] : undefined
            }, undefined, false, undefined, this),
            state.type === "start" && /* @__PURE__ */ jsxDEV(Fragment, {
              children: [
                /* @__PURE__ */ jsxDEV("input", {
                  type: "hidden",
                  name: "action",
                  value: "register"
                }, undefined, false, undefined, this),
                /* @__PURE__ */ jsxDEV("input", {
                  "data-component": "input",
                  autofocus: !error || emailError,
                  type: "email",
                  name: "email",
                  value: !emailError ? form?.get("email")?.toString() : "",
                  required: true,
                  placeholder: copy.input_email
                }, undefined, false, undefined, this),
                /* @__PURE__ */ jsxDEV("input", {
                  "data-component": "input",
                  autofocus: passwordError,
                  type: "password",
                  name: "password",
                  placeholder: copy.input_password,
                  required: true,
                  value: !passwordError ? form?.get("password")?.toString() : "",
                  autoComplete: "new-password"
                }, undefined, false, undefined, this),
                /* @__PURE__ */ jsxDEV("input", {
                  "data-component": "input",
                  type: "password",
                  name: "repeat",
                  required: true,
                  autofocus: passwordError,
                  placeholder: copy.input_repeat,
                  autoComplete: "new-password"
                }, undefined, false, undefined, this),
                /* @__PURE__ */ jsxDEV("button", {
                  "data-component": "button",
                  children: copy.button_continue
                }, undefined, false, undefined, this),
                /* @__PURE__ */ jsxDEV("div", {
                  "data-component": "form-footer",
                  children: /* @__PURE__ */ jsxDEV("span", {
                    children: [
                      copy.login_prompt,
                      " ",
                      /* @__PURE__ */ jsxDEV("a", {
                        "data-component": "link",
                        href: "authorize",
                        children: copy.login
                      }, undefined, false, undefined, this)
                    ]
                  }, undefined, true, undefined, this)
                }, undefined, false, undefined, this)
              ]
            }, undefined, true, undefined, this),
            state.type === "code" && /* @__PURE__ */ jsxDEV(Fragment, {
              children: [
                /* @__PURE__ */ jsxDEV("input", {
                  type: "hidden",
                  name: "action",
                  value: "verify"
                }, undefined, false, undefined, this),
                /* @__PURE__ */ jsxDEV("input", {
                  "data-component": "input",
                  autofocus: true,
                  name: "code",
                  minLength: 6,
                  maxLength: 6,
                  required: true,
                  placeholder: copy.input_code,
                  autoComplete: "one-time-code"
                }, undefined, false, undefined, this),
                /* @__PURE__ */ jsxDEV("button", {
                  "data-component": "button",
                  children: copy.button_continue
                }, undefined, false, undefined, this)
              ]
            }, undefined, true, undefined, this)
          ]
        }, undefined, true, undefined, this)
      }, undefined, false, undefined, this);
      return new Response(jsx.toString(), {
        headers: {
          "Content-Type": "text/html"
        }
      });
    },
    change: async (_req, state, form, error) => {
      const passwordError = [
        "invalid_password",
        "password_mismatch",
        "validation_error"
      ].includes(error?.type || "");
      const jsx = /* @__PURE__ */ jsxDEV(Layout, {
        children: [
          /* @__PURE__ */ jsxDEV("form", {
            "data-component": "form",
            method: "post",
            replace: true,
            children: [
              /* @__PURE__ */ jsxDEV(FormAlert, {
                message: error?.type ? error.type === "validation_error" ? error.message ?? copy?.[`error_${error.type}`] : copy?.[`error_${error.type}`] : undefined
              }, undefined, false, undefined, this),
              state.type === "start" && /* @__PURE__ */ jsxDEV(Fragment, {
                children: [
                  /* @__PURE__ */ jsxDEV("input", {
                    type: "hidden",
                    name: "action",
                    value: "code"
                  }, undefined, false, undefined, this),
                  /* @__PURE__ */ jsxDEV("input", {
                    "data-component": "input",
                    autofocus: true,
                    type: "email",
                    name: "email",
                    required: true,
                    value: form?.get("email")?.toString(),
                    placeholder: copy.input_email
                  }, undefined, false, undefined, this)
                ]
              }, undefined, true, undefined, this),
              state.type === "code" && /* @__PURE__ */ jsxDEV(Fragment, {
                children: [
                  /* @__PURE__ */ jsxDEV("input", {
                    type: "hidden",
                    name: "action",
                    value: "verify"
                  }, undefined, false, undefined, this),
                  /* @__PURE__ */ jsxDEV("input", {
                    "data-component": "input",
                    autofocus: true,
                    name: "code",
                    minLength: 6,
                    maxLength: 6,
                    required: true,
                    placeholder: copy.input_code,
                    autoComplete: "one-time-code"
                  }, undefined, false, undefined, this)
                ]
              }, undefined, true, undefined, this),
              state.type === "update" && /* @__PURE__ */ jsxDEV(Fragment, {
                children: [
                  /* @__PURE__ */ jsxDEV("input", {
                    type: "hidden",
                    name: "action",
                    value: "update"
                  }, undefined, false, undefined, this),
                  /* @__PURE__ */ jsxDEV("input", {
                    "data-component": "input",
                    autofocus: true,
                    type: "password",
                    name: "password",
                    placeholder: copy.input_password,
                    required: true,
                    value: !passwordError ? form?.get("password")?.toString() : "",
                    autoComplete: "new-password"
                  }, undefined, false, undefined, this),
                  /* @__PURE__ */ jsxDEV("input", {
                    "data-component": "input",
                    type: "password",
                    name: "repeat",
                    required: true,
                    value: !passwordError ? form?.get("password")?.toString() : "",
                    placeholder: copy.input_repeat,
                    autoComplete: "new-password"
                  }, undefined, false, undefined, this)
                ]
              }, undefined, true, undefined, this),
              /* @__PURE__ */ jsxDEV("button", {
                "data-component": "button",
                children: copy.button_continue
              }, undefined, false, undefined, this)
            ]
          }, undefined, true, undefined, this),
          state.type === "code" && /* @__PURE__ */ jsxDEV("form", {
            method: "post",
            children: [
              /* @__PURE__ */ jsxDEV("input", {
                type: "hidden",
                name: "action",
                value: "code"
              }, undefined, false, undefined, this),
              /* @__PURE__ */ jsxDEV("input", {
                type: "hidden",
                name: "email",
                value: state.email
              }, undefined, false, undefined, this),
              state.type === "code" && /* @__PURE__ */ jsxDEV("div", {
                "data-component": "form-footer",
                children: [
                  /* @__PURE__ */ jsxDEV("span", {
                    children: [
                      copy.code_return,
                      " ",
                      /* @__PURE__ */ jsxDEV("a", {
                        "data-component": "link",
                        href: "authorize",
                        children: copy.login.toLowerCase()
                      }, undefined, false, undefined, this)
                    ]
                  }, undefined, true, undefined, this),
                  /* @__PURE__ */ jsxDEV("button", {
                    "data-component": "link",
                    children: copy.code_resend
                  }, undefined, false, undefined, this)
                ]
              }, undefined, true, undefined, this)
            ]
          }, undefined, true, undefined, this)
        ]
      }, undefined, true, undefined, this);
      return new Response(jsx.toString(), {
        status: error ? 400 : 200,
        headers: {
          "Content-Type": "text/html"
        }
      });
    }
  };
}
export {
  PasswordUI
};
