import type { OAuth2Tokens } from "../oauth2.js";
export declare class GitLab {
    private authorizationEndpoint;
    private tokenEndpoint;
    private tokenRevocationEndpoint;
    private client;
    constructor(domain: string, clientId: string, clientSecret: string, redirectURI: string);
    createAuthorizationURL(state: string, scopes: string[]): URL;
    validateAuthorizationCode(code: string): Promise<OAuth2Tokens>;
    refreshAccessToken(refreshToken: string): Promise<OAuth2Tokens>;
    revokeToken(token: string): Promise<void>;
}
